/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.core.Debugger;
import jace.core.Device;

public abstract class CPU
extends Device {
    private Debugger debugger = null;
    @ConfigurableField(name="Enable trace")
    public boolean trace = false;
    public int programCounter = 0;

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public void setTraceEnabled(boolean t) {
        this.trace = t;
    }

    public void setDebug(Debugger d) {
        this.debugger = d;
        this.suspend();
    }

    public void clearDebug() {
        this.debugger = null;
        this.resume();
    }

    public int getProgramCounter() {
        return this.programCounter;
    }

    public void setProgramCounter(int programCounter) {
        this.programCounter = 0xFFFF & programCounter;
    }

    public void incrementProgramCounter(int amount) {
        this.programCounter += amount;
        this.programCounter = 0xFFFF & this.programCounter;
    }

    @Override
    public void tick() {
        this.executeOpcode();
        if (this.debugger != null) {
            if (!this.debugger.isActive() && this.debugger.hasBreakpoints()) {
                for (int i : this.debugger.getBreakpoints()) {
                    if (i != this.getProgramCounter()) continue;
                    this.debugger.setActive(true);
                }
            }
            if (this.debugger.isActive()) {
                this.suspend();
                this.debugger.updateStatus();
            }
        }
    }

    protected abstract void executeOpcode();

    public abstract void reset();

    public abstract void generateInterrupt();

    @Override
    public void suspend() {
        this.setRun(false);
    }

    @Override
    public void resume() {
        this.setRun(true);
    }

    public abstract void pushPC();

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }
}

